import sys
import pysam


library = sys.argv[1]


def parse_alignments(bamfile):
    alignments = []
    current = None
    for alignment in bamfile:
        qname = alignment.qname
        assert qname.startswith("seq_")
        number = int(qname[4:])
        if qname != current:
            if current is not None:
                yield alignments
            current = qname
            alignments = []
        alignments.append(alignment)
    yield alignments

filename = "seqlist.bam"
print("Reading", filename)
bamfile = pysam.AlignmentFile(filename)
alignments = parse_alignments(bamfile)

filename = "%s.bam" % library
print("Writing", filename)

output = pysam.AlignmentFile(filename, 'wb', template=bamfile) 

filename = "%s.index.txt" % library

current = None
print("Reading", filename)
handle = open(filename)
for line in handle:
    qname, seqname = line.split()
    assert seqname.startswith("seq_")
    if seqname != current:
        for block in alignments:
            current = block[0].qname
            if seqname == current:
                break
        else:  # reached end of mapping file without finding sequence
            raise Exception("Failed to find %s" % seqname)
    for alignment in block:
        alignment.qname = qname
        output.write(alignment)

output.close()
handle.close()
bamfile.close()
